# -*- coding: utf-8 -*-

from lutio.format import LUT3DFormat

__all__ = ['Quantel3DLUTFormat']

#
# Helper

LUSTRE3DLUT_TEMPLATE = """max value {bitrange}
vertices {size}
blue is fastest changing
red is slowest changing

cube data
R G B
{values}
"""


#
# Master

class Quantel3DLUTFormat(LUT3DFormat):
    class Meta:
        name = "Quantel"
        extensions = (".txt",)

    metakey = 'quantel'

    supported_sizes = (17,)
    supported_bitdepths = (12,)

    def __init__(self, size=17, bitdepth=12):
        super().__init__(size, bitdepth)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)
        values = self._lut_to_str_(lut, fmt="%d")

        with open(filename, 'w') as f:
            f.write(LUSTRE3DLUT_TEMPLATE.format(bitrange=2 ** self.bitdepth - 1,
                                                size=self.size,
                                                values=values))
