# -*- coding: utf-8 -*-

from lutio.format import LUT3DFormat

__all__ = ['Luther3DLUTFormat']

#
# Helper

LUTHER3DLUT_TEMPLATE = """#channels: c3
#elements = {flatsize}
{values}
"""


#
# Master

class Luther3DLUTFormat(LUT3DFormat):
    class Meta:
        name = "DFT Luther"
        extensions = (".txt",)

    metakey = 'luther'

    supported_sizes = (17, 33, 65)
    supported_bitdepths = (10,)

    def __init__(self, size=33, bitdepth=10):
        super().__init__(size, bitdepth)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)
        values = self._lut_to_str_(lut, fmt="%d")

        with open(filename, 'w') as f:
            f.write(LUTHER3DLUT_TEMPLATE.format(flatsize=self.size ** 3,
                                                values=values))
