# -*- coding: utf-8 -*-

from lutio.format import LUT3DFormat

__all__ = ['FilmlightLUT3DFormat']


#
# Helper

FILMLIGHTLUT3D_TEMPLATE = """# Truelight Cube v2.0
# iDims     3
# oDims     3
# width     {size} {size} {size}

# Cube
{values}
# end
"""


#
# Master

class FilmlightLUT3DFormat(LUT3DFormat):
    class Meta:
        extensions = (".cube",)
        name = "Filmlight"

    metakey = 'filmlight'

    supported_sizes = (16, 32, 64)

    def __init__(self, size=32):
        super().__init__(size)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)

        lut = lut.transpose(2, 1, 0, 3)
        values = self._lut_to_str_(lut)

        with open(filename, 'w') as f:
            f.write(FILMLIGHTLUT3D_TEMPLATE.format(size=self.size,
                                                   values=values))
