# -*- coding: utf-8 -*-

from lutio.format import LUT3DFormat

__all__ = ['AfterEffectsLUT3Format', 'DavinciLUT3Format', 'IridasLUT3Format',
           'NukeLUT3Format']

#
# Helper

CUBELUT3D_TEMPLATE = """LUT_3D_SIZE {size}
{values}
"""


#
# Master

class CubeLUT3DFormat(LUT3DFormat):
    supported_sizes = (16, 17, 32, 33, 64, 65)

    def __init__(self, size=32):
        super().__init__(size)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)

        lut = lut.transpose(2, 1, 0, 3)
        values = self._lut_to_str_(lut)

        with open(filename, 'w') as f:
            f.write(CUBELUT3D_TEMPLATE.format(size=self.size,
                                              values=values))


class AfterEffectsLUT3Format(CubeLUT3DFormat):
    class Meta:
        extensions = (".cube",)
        name = "Adobe After Effects"

    metakey = 'aftereffects'


class DavinciLUT3Format(CubeLUT3DFormat):
    class Meta:
        extensions = (".cube",)
        name = "DaVinci Cube"

    metakey = 'davinci'

    supported_sizes = (33,)

    def __init__(self, size=33):
        super().__init__(size)


class IridasLUT3Format(CubeLUT3DFormat):
    class Meta:
        extensions = (".cube",)
        name = "Iridas"

    metakey = 'iridas'


class NukeLUT3Format(CubeLUT3DFormat):
    class Meta:
        extensions = (".cube",)
        name = "TheFoundry Nuke"

    metakey = 'nuke'
