# -*- coding: utf-8 -*-

__all__ = ['MetaRegistry', 'MetaMetaRegistry']


class MetaMetaRegistry(type):
    def subclasses(self):
        return [s for s in self.__subclasses__() if 'metakey' in s.__dict__] + \
               [ss for s in self.__subclasses__() for ss in s.subclasses()]

    def __getitem__(self, item):
        if isinstance(item, type(self)):
            if item in self.subclasses():
                return item
            else:
                raise KeyError(item)
        elif isinstance(item, str):
            try:
                return next(x for x in self.subclasses() if x == item)
            except StopIteration:
                raise KeyError(item)
        else:
            raise KeyError(item)

    def __contains__(self, item):
        try:
            self[item]
        except KeyError:
            return False
        else:
            return True

    def __eq__(self, other):
        if isinstance(other, self):
            return self.__dict__ == other.__dict__
        else:
            try:
                return getattr(self, 'metakey') == other
            except AttributeError:
                pass

        return NotImplemented

    def __ne__(self, other):
        return not MetaMetaRegistry.__eq__(self, other)

    def __hash__(self):
        return super().__hash__()


class MetaRegistry(metaclass=MetaMetaRegistry):
    pass
