# -*- coding: utf-8 -*-
import numpy as np

__all__ = ['clamp', 'scale', 'linremap', 'is3dlut']


def clamp(lut):
    min_ = lut.min()
    return (lut - min_) / (lut.max() - min_)


def scale(lut, min_, max_):
    return min_ + lut * (max_ - min_)


def linremap(lut, min_in, max_in, min_out, max_out):
    return min_out + (max_out - min_out) / (max_in - min_in) * (lut - min_in)


def is3dlut(lut):
    return lut.ndim == 4 and np.array_equal(lut.shape[:3], lut.shape[0])
