# -*- coding: utf-8 -*-
import numpy as np

from lutio.format import LUT3DFormat

__all__ = ['ColorfrontLUT3DFormat']


#
# Master

class ColorfrontLUT3DFormat(LUT3DFormat):
    class Meta:
        extensions = (".3dmesh",)
        name = "Colorfront 3D"

    metakey = 'colorfront'

    supported_sizes = (9, 17, 33, 65)

    def __init__(self, size=17):
        super().__init__(size)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)

        with open(filename, 'wb') as f:
            np.savetxt(f, lut.reshape(-1, 3), fmt="%08.6f")
