# -*- coding: utf-8 -*-

from lutio.format import LUT3DFormat

__all__ = ['Codex3DLUTFormat']

#
# Helper

LUSTRE3DLUT_TEMPLATE = """Lut3D {size}

R\tG\tB
{values}
"""


#
# Master

class Codex3DLUTFormat(LUT3DFormat):
    class Meta:
        name = "Codex Digital"
        extensions = (".txt",)

    metakey = 'codex'

    supported_sizes = (17,)
    supported_bitdepths = (12,)

    def __init__(self, size=17, bitdepth=12):
        super().__init__(size, bitdepth)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)
        values = self._lut_to_str_(lut, fmt="%d")

        with open(filename, 'w') as f:
            f.write(LUSTRE3DLUT_TEMPLATE.format(size=self.size,
                                                values=values))
