# -*- coding: utf-8 -*-
import os

from lutio.format import LUT3DFormat

__all__ = ['ClipsterLUT3DFormat']

#
# Helper

CLIPSTERLUT3D_TEMPLATE = """<LUT3D name='{stem}' N='{size}' \
BitDepth='{bitdepth}'>
<values>
{values}
</values>
</LUT3D>
"""


#
# Master

class ClipsterLUT3DFormat(LUT3DFormat):
    class Meta:
        extensions = (".txt",)
        name = "DVS Clipster"

    metakey = 'clipster'

    supported_sizes = (17,)
    supported_bitdepths = (16,)

    def __init__(self, size=17, bitdepth=16):
        super().__init__(size, bitdepth)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)
        values = self._lut_to_str_(lut, fmt="%d")

        with open(filename, 'w') as f:
            stem = os.path.splitext(os.path.basename(filename))[0]

            f.write(CLIPSTERLUT3D_TEMPLATE.format(stem=stem,
                                                  size=self.size,
                                                  bitdepth=self.bitdepth,
                                                  values=values))
