# -*- coding: utf-8 -*-
from lutio.format import LUT3DFormat

__all__ = ['CanonLUT3DFormat']


#
# Helper

CANONLUT3D_TEMPLATE = """type\tgamut
size\t{size}
order\t{order}
values
{values}
"""


#
# Master

class CanonLUT3DFormat(LUT3DFormat):
    class Meta:
        extensions = (".clut",)
        name = "Canon"

    metakey = 'canon'

    supported_sizes = (9, 17, 33, 65)

    def __init__(self, size=17):
        super().__init__(size)

    def to_file(self, lut, filename):
        lut, filename = self._prepare_to_file_(lut, filename)
        values = self._lut_to_str_(lut, fmt="%010.8f")

        with open(filename, 'w') as f:
            f.write(CANONLUT3D_TEMPLATE.format(size=self.size,
                                               order="bottom",
                                               values=values))
