# -*- coding: utf-8 -*-
from enum import Enum

import numpy as np
from .format import LUT3DFormat

__all__ = ['ExportStatus', 'buffer_to_lut3dfile']


#
# Definitions

class ExportStatus(Enum):
    Succeeded = 0
    Failed = 1


#
# API methods

def buffer_to_lut3dfile(buffer, src_size, dst_format, dst_size, filename):
    if buffer.format != 'd':
        buffer = buffer.cast('d')

    lut = np.frombuffer(buffer, dtype=np.float)
    lut = lut.reshape(src_size, src_size, src_size, 3)

    # noinspection PyBroadException
    try:
        LUT3DFormat[dst_format](dst_size).to_file(lut, filename)
    except Exception:
        return 1
    else:
        return 0
