// Copyright Epic Games, Inc. All Rights Reserved.

#include "ArriCamMetadataBPLibrary.h"
#include "Common/UdpSocketBuilder.h"
#include "Sockets.h"
#include "SocketSubsystem.h"

#define RECV_BUFFER_SIZE 1024 * 1024

UArriDevice* UArriCamMetadataBPLibrary::initDevice(const UDPMode Mode, const FString IPAddress, const int UDPPortNumber, const FString MulticastAddress)
{
	bool createSocket = true;

	UArriDevice* ArriDevice = NewObject<UArriDevice>();

	ArriDevice->mConnectionSettings.Mode = Mode;
	ArriDevice->mConnectionSettings.IPAddress = IPAddress;
	ArriDevice->mConnectionSettings.UDPPortNumber = UDPPortNumber;
	ArriDevice->mConnectionSettings.MulticastAddress = MulticastAddress;

	ArriDevice->mSocket = UArriDevice::createSocket(ArriDevice->mConnectionSettings, ArriDevice->mSocket);
	ArriDevice->Start();

	return ArriDevice;
}

FArriSensorDimensions UArriCamMetadataBPLibrary::getAlexaMiniLFSensorSize(AlexaMiniLF AlexaMiniLFPreset)
{
	FArriSensorDimensions SensorDimensions;

	if (AlexaMiniLFPreset == AlexaMiniLF::ARRIRAW_45K_LF_32_OG_45K || AlexaMiniLFPreset == AlexaMiniLF::PRORES_45K_LF_32_OG_45K)
	{
		SensorDimensions.sensorWidth = 36.7;
		SensorDimensions.sensorHeight = 25.54;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::ARRIRAW_45K_LF_2391_45K || AlexaMiniLFPreset == AlexaMiniLF::PRORES_45K_LF_2391_45K)
	{
		SensorDimensions.sensorWidth = 36.7;
		SensorDimensions.sensorHeight = 15.31;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::ARRIRAW_38K_LF_169_UHD || AlexaMiniLFPreset == AlexaMiniLF::PRORES_38K_LF_169_UHD ||
		AlexaMiniLFPreset == AlexaMiniLF::PRORES_38K_LF_169_2K || AlexaMiniLFPreset == AlexaMiniLF::PRORES_38K_LF_169_HD)
	{
		SensorDimensions.sensorWidth = 31.68;
		SensorDimensions.sensorHeight = 17.82;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::ARRIRAW_28K_LF_11_28K || AlexaMiniLFPreset == AlexaMiniLF::PRORES_28K_LF_11_28K)
	{
		SensorDimensions.sensorWidth = 23.76;
		SensorDimensions.sensorHeight = 23.76;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::ARRIRAW_34K_S35_32_34K)
	{
		SensorDimensions.sensorWidth = 28.25;
		SensorDimensions.sensorHeight = 18.17;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::PRORES_43K_LF_169_UHD || AlexaMiniLFPreset == AlexaMiniLF::PRORES_43K_LF_169_HD)
	{
		SensorDimensions.sensorWidth = 35.64;
		SensorDimensions.sensorHeight = 20.05;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::PRORES_32K_S35_169_32K)
	{
		SensorDimensions.sensorWidth = 26.40;
		SensorDimensions.sensorHeight = 14.85;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::PRORES_28K_S35_43_28K)
	{
		SensorDimensions.sensorWidth = 23.76;
		SensorDimensions.sensorHeight = 17.82;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::PRORES_28K_S35_169_HD)
	{
		SensorDimensions.sensorWidth = 23.76;
		SensorDimensions.sensorHeight = 13.37;
	}
	else if (AlexaMiniLFPreset == AlexaMiniLF::NONE)
	{
		SensorDimensions.sensorWidth = 0;
		SensorDimensions.sensorHeight = 0;
	}

	return SensorDimensions;
}

FArriSensorDimensions UArriCamMetadataBPLibrary::getAlexaMiniSensorSize(AlexaMini AlexaMiniPreset)
{
	FArriSensorDimensions SensorDimensions;

	if (AlexaMiniPreset == AlexaMini::ARRIRAW_OG_34K)
	{
		SensorDimensions.sensorWidth = 28.25;
		SensorDimensions.sensorHeight = 18.17;
	}
	else if (AlexaMiniPreset == AlexaMini::PRORES_169_32K || AlexaMiniPreset == AlexaMini::PRORES_169_4K_UHD)
	{
		SensorDimensions.sensorWidth = 26.40;
		SensorDimensions.sensorHeight = 14.85;
	}
	else if (AlexaMiniPreset == AlexaMini::ARRIRAW_28K_43 || AlexaMiniPreset == AlexaMini::PRORES_43_28K)
	{
		SensorDimensions.sensorWidth = 23.76;
		SensorDimensions.sensorHeight = 17.82;
	}
	else if (AlexaMiniPreset == AlexaMini::ARRIRAW_28K_169)
	{
		SensorDimensions.sensorWidth = 27.26;
		SensorDimensions.sensorHeight = 13.37;
	}
	else if (AlexaMiniPreset == AlexaMini::ARRIRAW_169_HD_ANA)
	{
		SensorDimensions.sensorWidth = 15.84;
		SensorDimensions.sensorHeight = 17.82;
	}
	else if (AlexaMiniPreset == AlexaMini::PRORES_169_2K)
	{
		SensorDimensions.sensorWidth = 23.66;
		SensorDimensions.sensorHeight = 13.3;
	}
	else if (AlexaMiniPreset == AlexaMini::PRORES_2391_2K_ANA)
	{
		SensorDimensions.sensorWidth = 21.12;
		SensorDimensions.sensorHeight = 17.7;
	}
	return SensorDimensions;
}

FArriSensorDimensions UArriCamMetadataBPLibrary::getAlexaLFSensorSize(AlexaLF AlexaLFPreset)
{
	FArriSensorDimensions SensorDimensions;

	if (AlexaLFPreset == AlexaLF::ARRIRAW_LF_OG_45K || AlexaLFPreset == AlexaLF::PRORES_LF_OG_45K)
	{
		SensorDimensions.sensorWidth = 36.7;
		SensorDimensions.sensorHeight = 25.54;
	}
	else if (AlexaLFPreset == AlexaLF::ARRIRAW_LF_2391_Scope_45K || AlexaLFPreset == AlexaLF::PRORES_LF_2391_Scope_45K)
	{
		SensorDimensions.sensorWidth = 36.7;
		SensorDimensions.sensorHeight = 15.31;
	}
	else if (AlexaLFPreset == AlexaLF::ARRIRAW_LF_169_4K_UHD || AlexaLFPreset == AlexaLF::PRORES_LF_169_HD ||
			 AlexaLFPreset == AlexaLF::PRORES_LF_169_2K || AlexaLFPreset == AlexaLF::PRORES_LF_169_4K_UHD)
	{
		SensorDimensions.sensorWidth = 31.68;
		SensorDimensions.sensorHeight = 17.82;
	}
	return SensorDimensions;
}

FArriSensorDimensions UArriCamMetadataBPLibrary::getAlexa65SensorSize(Alexa65 Alexa65Preset)
{
	FArriSensorDimensions SensorDimensions;

	if (Alexa65Preset == Alexa65::ARRIRAW_LF_OG_45K)
	{
		SensorDimensions.sensorWidth = 36.7;
		SensorDimensions.sensorHeight = 25.54;
	}
	else if (Alexa65Preset == Alexa65::ARRIRAW_169_4K_UHD)
	{
		SensorDimensions.sensorWidth = 31.68;
		SensorDimensions.sensorHeight = 17.82;
	}
	else if (Alexa65Preset == Alexa65::ARRIRAW_OG_65K)
	{
		SensorDimensions.sensorWidth = 54.12;
		SensorDimensions.sensorHeight = 25.58;
	}
	else if (Alexa65Preset == Alexa65::ARRIRAW_169_51K)
	{
		SensorDimensions.sensorWidth = 42.24;
		SensorDimensions.sensorHeight = 23.76;
	}
	else if (Alexa65Preset == Alexa65::ARRIRAW_32_43K)
	{
		SensorDimensions.sensorWidth = 35.64;
		SensorDimensions.sensorHeight = 23.76;
	}

	return SensorDimensions;
}

FArriSensorDimensions UArriCamMetadataBPLibrary::getAmiraSensorSize(Amira AmiraPreset)
{
	FArriSensorDimensions SensorDimensions;

	if (AmiraPreset == Amira::PRORES_169_32K || AmiraPreset == Amira::PRORES_169_4K_UHD)
	{
		SensorDimensions.sensorWidth = 26.40;
		SensorDimensions.sensorHeight = 14.85;
	}
	else if (AmiraPreset == Amira::ARRIRAW_169_28K || AmiraPreset == Amira::PRORES_169_HD)
	{
		SensorDimensions.sensorWidth = 23.76;
		SensorDimensions.sensorHeight = 13.37;
	}
	else if (AmiraPreset == Amira::PRORES_169_2K)
	{
		SensorDimensions.sensorWidth = 23.66;
		SensorDimensions.sensorHeight = 13.3;
	}
	else if (AmiraPreset == Amira::PRORES_169_S16_HD)
	{
		SensorDimensions.sensorWidth = 13.2;
		SensorDimensions.sensorHeight = 7.43;
	}

	return SensorDimensions;
}