// Fill out your copyright notice in the Description page of Project Settings.


#include "ArriLiveLinkCameraController.h"
#include "Roles/LiveLinkCameraTypes.h"
#include "CineCameraComponent.h"

UArriLiveLinkCameraController::UArriLiveLinkCameraController()
{

}

void UArriLiveLinkCameraController::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
	ULiveLinkCameraController::PostEditChangeProperty(PropertyChangedEvent);
	const FName PropertyName = (PropertyChangedEvent.Property != NULL) ? PropertyChangedEvent.Property->GetFName() : NAME_None;

	if (UCameraComponent* CameraComponent = Cast<UCameraComponent>(AttachedComponent))
	{
		if (UCineCameraComponent* CineCameraComponent = Cast<UCineCameraComponent>(CameraComponent))
		{
			if (setFilmback)
			{
				FArriSensorDimensions SensorSize;

				if (ArriCamera == ArriCameraType::ALEXAMINILF)
				{
					SensorSize = UArriCamMetadataBPLibrary::getAlexaMiniLFSensorSize(AlexaMiniLFPreset);

					CineCameraComponent->Filmback.SensorWidth = SensorSize.sensorWidth;
					CineCameraComponent->Filmback.SensorHeight = SensorSize.sensorHeight;
				}
				if (ArriCamera == ArriCameraType::ALEXA65)
				{
					SensorSize = UArriCamMetadataBPLibrary::getAlexa65SensorSize(Alexa65Preset);

					CineCameraComponent->Filmback.SensorWidth = SensorSize.sensorWidth;
					CineCameraComponent->Filmback.SensorHeight = SensorSize.sensorHeight;
				}
				else if (ArriCamera == ArriCameraType::ALEXALF)
				{
					SensorSize = UArriCamMetadataBPLibrary::getAlexaLFSensorSize(AlexaLFPreset);

					CineCameraComponent->Filmback.SensorWidth = SensorSize.sensorWidth;
					CineCameraComponent->Filmback.SensorHeight = SensorSize.sensorHeight;
				}
				else if (ArriCamera == ArriCameraType::AMIRA)
				{
					SensorSize = UArriCamMetadataBPLibrary::getAmiraSensorSize(AmiraPreset);

					CineCameraComponent->Filmback.SensorWidth = SensorSize.sensorWidth;
					CineCameraComponent->Filmback.SensorHeight = SensorSize.sensorHeight;
				}
				else if(ArriCamera == ArriCameraType::ALEXAMINI)
				{
					SensorSize = UArriCamMetadataBPLibrary::getAlexaMiniSensorSize(AlexaMiniPreset);

					CineCameraComponent->Filmback.SensorWidth = SensorSize.sensorWidth;
					CineCameraComponent->Filmback.SensorHeight = SensorSize.sensorHeight;
				}
			}
		}
	}
}

void UArriLiveLinkCameraController::Tick(float DeltaTime, const FLiveLinkSubjectFrameData& SubjectData)
{
	ULiveLinkCameraController::Tick(DeltaTime, SubjectData);

	const FLiveLinkCameraStaticData* StaticData = SubjectData.StaticData.Cast<FLiveLinkCameraStaticData>();
	const FLiveLinkCameraFrameData* FrameData = SubjectData.FrameData.Cast<FLiveLinkCameraFrameData>();

	if (UCameraComponent* CameraComponent = Cast<UCameraComponent>(AttachedComponent))
	{
		if (UCineCameraComponent* CineCameraComponent = Cast<UCineCameraComponent>(CameraComponent))
		{
			CineCameraComponent->FocusSettings.ManualFocusDistance = FrameData->FocusDistance * depthOfFieldMultiplier;
			if (overrideIris == true)
			{
				CineCameraComponent->CurrentAperture = newIris;
			}			
		}
	}
}
