#pragma once
#include "ArriMetadata.generated.h"

UENUM()
enum class NDFilterType : uint8
{
	ND_OFF UMETA(DisplayName = "NDFilter Off"),
	ND_ON UMETA(DisplayName = "NDFilter On"),
	ND_UNKNOWN UMETA(DisplayName = "NDFilter unknown")
};

UENUM()
enum class CameraState : uint8
{
	CS_UNKNOWN UMETA(DisplayName = "CameraSystem Unknown state"),
	CS_READY UMETA(DisplayName = "CameraSystem Ready"),
	CS_RECORDING UMETA(DisplayName = "CameraSystem Recording"),
	CS_REC_STARTING UMETA(DisplayName = "CameraSystem Recording start"),
	CS_REC_STOPPING UMETA(DisplayName = "CameraSystem Recording stop"),
	CS_WARNING_ACTIVE UMETA(DisplayName = "CameraSystem Warning"),
	CS_ERROR_ACTIVE UMETA(DisplayName = "CameraSystem Error"),
	CS_NOT_READY UMETA(DisplayName = "CameraSystem Not Ready"),
	CS_BOOTING UMETA(DisplayName = "CameraSystem Booting"),
	CS_UPDATING UMETA(DisplayName = "CameraSystem Updating"),
	CS_UPDATE_FINISHED UMETA(DisplayName = "CameraSystem Update Finished"),
	CS_PRE_RECORDING UMETA(DisplayName = "CameraSystem Prerecording"),
	CS_PREREC_STARTING UMETA(DisplayName = "CameraSystem Starting Prerecording"),
	CS_PLAYBACK UMETA(DisplayName = "CameraSystem Playback"),
	CS_MEDIUM_FORMAT UMETA(DisplayName = "CameraSystem Formatting Medium")
};

USTRUCT(BlueprintType)
struct FArriMetadata
{
	GENERATED_BODY()

	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	CameraState cameraState;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString cameraModel;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString cameraSerial;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString cameraSoftwareVersion;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString umcSerialNumber;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString umcSoftwareVersion;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float ndFilterDensity;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	NDFilterType ndFilterType;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString lensName;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString lensSerialNumber;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString focusUnit;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float focusDistance;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float aperture;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float focalLength;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float shutterAngle;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float exposureTime;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int exposureIndex;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int mediaCapacity;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FFrameRate framerate;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FFrameTime frameNumber;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	bool dropFrame;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FTimecode timecode;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int clipNumber;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	FString cameraIndex;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int cct;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float tint;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsFocusMin;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsFocusMax;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsIrisMin;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsIrisMax;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsFLMin;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderLimitsFLMax;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int lensRawEncoderFocus = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int lensRawEncoderFocalLength = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int lensRawEncoderIris = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderFocus = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderFocalLength = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	int motorRawEncoderIris = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float tilt = 0;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ArriCamMetadata")
	float roll = 0;
};