#pragma once
#include "rawMetadata.generated.h"

USTRUCT()
struct FOrientation
{
	GENERATED_BODY()

	UPROPERTY()
	float tilt;
	UPROPERTY()
	float roll;
};

USTRUCT()
struct FPositional
{
	GENERATED_BODY()

	UPROPERTY()
	FOrientation orientation;
};

USTRUCT()
struct FWhitebalance
{
	GENERATED_BODY()

	UPROPERTY()
	uint32 cct;
	UPROPERTY()
	int32 tint;
};

USTRUCT()
struct FProcessing
{
	GENERATED_BODY()

	UPROPERTY()
	FWhitebalance whitebalance;
};

USTRUCT()
struct FRecordingSlateInfo
{
	GENERATED_BODY()

	UPROPERTY()
	FString cameraIndex;
};

USTRUCT()
struct FRecordingClipInfo
{
	GENERATED_BODY()

	UPROPERTY()
	uint32 clipNumber;
};

USTRUCT()
struct FRecordingClip
{
	GENERATED_BODY()

	UPROPERTY()
	FRecordingClipInfo clipInfo;
	UPROPERTY()
	FRecordingSlateInfo slateInfo;
};

USTRUCT()
struct FRecordingProjectRate
{
	GENERATED_BODY()

	UPROPERTY()
	float timebase;
	UPROPERTY()
	bool dropframe;
};

USTRUCT()
struct FRecordingMedia
{
	GENERATED_BODY()

	UPROPERTY()
	uint32 capacity;

};

USTRUCT()
struct FRecording
{
	GENERATED_BODY()

	UPROPERTY()
	FRecordingMedia media;
	UPROPERTY()
	FRecordingProjectRate projectRate;
	UPROPERTY()
	int32 acquisitionTimestamp;
	UPROPERTY()
	FRecordingClip clip;
};

USTRUCT()
struct FSensor
{
	GENERATED_BODY()

	UPROPERTY()
	float shutterAngle;
	UPROPERTY()
	uint32 exposureTime;
	UPROPERTY()
	uint32 exposureIndex;
};

USTRUCT()
struct FOpticLensState
{
	GENERATED_BODY()

	UPROPERTY()
	FString focusUnit;
	UPROPERTY()
	float focusDistanceMetric;
	UPROPERTY()
	float focusDistanceImperial;
	UPROPERTY()
	FString irisAsText;
	UPROPERTY()
	float iris;
	UPROPERTY()
	float focalLength;
	UPROPERTY()
	int32 lensRawEncoderValueFocus;
	UPROPERTY()
	int32 lensRawEncoderValueIris;
	UPROPERTY()
	int32 lensRawEncoderValueFL;
	UPROPERTY()
	int32 motorRawEncoderValueFocus;
	UPROPERTY()
	int32 motorRawEncoderValueIris;
	UPROPERTY()
	int32 motorRawEncoderValueFL;
};

USTRUCT()
struct FMotorRawEncoderLimitsFL
{
	GENERATED_BODY()

	UPROPERTY()
	int32 min;
	UPROPERTY()
	int32 max;
};

USTRUCT()
struct FMotorRawEncoderLimitsIris
{
	GENERATED_BODY()

	UPROPERTY()
	int32 min;
	UPROPERTY()
	int32 max;
};

USTRUCT()
struct FMotorRawEncoderLimitsFocus
{
	GENERATED_BODY()

	UPROPERTY()
	int32 min;
	UPROPERTY()
	int32 max;
};

USTRUCT()
struct FOpticLensDevice
{
	GENERATED_BODY()

	UPROPERTY()
	FString model;
	UPROPERTY()
	FString serialNumber;
	UPROPERTY()
	FMotorRawEncoderLimitsFocus motorRawEncoderLimitsFocus;
	UPROPERTY()
	FMotorRawEncoderLimitsIris motorRawEncoderLimitsIris;
	UPROPERTY()
	FMotorRawEncoderLimitsFL motorRawEncoderLimitsFL;
};

USTRUCT()
struct FOpticLens
{
	GENERATED_BODY()

		UPROPERTY()
		FOpticLensDevice device;

		UPROPERTY()
		FOpticLensState state;
};

USTRUCT()
struct FOpticFilter
{
	GENERATED_BODY()

	UPROPERTY()
	float ndFilterDensity;
	UPROPERTY()
	uint32 ndFilterType;
};

USTRUCT()
struct FArriCameraOptic
{
	GENERATED_BODY()

	UPROPERTY()
	FOpticFilter filter;
	UPROPERTY()
	FOpticLens lens;
};

USTRUCT()
struct FArriCameraDevice
{
	GENERATED_BODY()

	UPROPERTY()
	FString model;
	UPROPERTY()
	FString umc4SerialNumber;
	UPROPERTY()
	FString umc4SoftwareVersion;
	UPROPERTY()
	FString serialNumber;
	UPROPERTY()
	FString softwareVersion;
};

USTRUCT()
struct FArriCameraState
{
	GENERATED_BODY()

	UPROPERTY()
	uint8 state;
	UPROPERTY()
	FArriCameraDevice device;
	UPROPERTY()
	FArriCameraOptic optic;
	UPROPERTY()
	FSensor sensor;
	UPROPERTY()
	FRecording recording;
	UPROPERTY()
	FProcessing processing;
	UPROPERTY()
	FPositional positional;

};

USTRUCT()
struct FArriCamera
{
	GENERATED_BODY()

	UPROPERTY()
	FArriCameraState camera;
};

USTRUCT()
struct FArriCameraRawMatadata
{
	GENERATED_BODY()

	UPROPERTY()
	FArriCamera metadata;
};