// Copyright Epic Games, Inc. All Rights Reserved.

#include "ArriCamMetadataBPLibrary.h"
#include "Common/UdpSocketBuilder.h"
#include "Sockets.h"
#include "SocketSubsystem.h"

#define RECV_BUFFER_SIZE 1024 * 1024

UArriDevice* UArriCamMetadataBPLibrary::initDevice(const UDPMode Mode, const FString IPAddress, const int UDPPortNumber, const FString MulticastAddress)
{
	bool createSocket = true;

	UArriDevice* ArriDevice = NewObject<UArriDevice>();

	ArriDevice->mConnectionSettings.Mode = Mode;
	ArriDevice->mConnectionSettings.IPAddress = IPAddress;
	ArriDevice->mConnectionSettings.UDPPortNumber = UDPPortNumber;
	ArriDevice->mConnectionSettings.MulticastAddress = MulticastAddress;

	ArriDevice->mSocket = UArriDevice::createSocket(ArriDevice->mConnectionSettings, ArriDevice->mSocket);
	ArriDevice->Start();

	return ArriDevice;
}
